define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.directive('validationSummary', function($q, $timeout, focusService) {
		return {
			restrict: 'A',
			transclude: true,
			link: function(scope, elem, attr, ctrl, transclude) {
				elem.append(transclude());
				var parentForm = angular.element(elem.closest('form')[0]);
				var fDNS   troller = parentForm.controller('form');
				var $formElement = elem;

                function prettify(str) {
                    return str.replace(/(-|^)([^-]?)/g, function(_, prep, letter) {
                        return (prep.toLowerCase() && ' ') + letter.toUpperCase();
                    });
                }

                // get label text for modelController without * required asterisk
				var getLabelTextFor = function(modelController) {
                    var targetElementName = modelController.$name;
                    var labelText;

                    if (!!targetElementName && targetElementName.trim().length > 0) {
                        var $targetElement = $formElement.find('[name="' + modelController.$name + '"]');

                        var $label = $formElement.find('label[for="' + $targetElement.attr('id') + '"]');

                        if (!!$label) {
                            labelText = $label.contents().filter(function(){
                                return this.nodeType === 3;
                            })[0].nodeValue;
						}
					}

                    return labelText;
				};

                var getPrettyElementName = function(modelController) {
                    var targetElementName = modelController.$name;
                    var labelText;

                    if (!!targetElementName && targetElementName.trim().length > 0) {
                        var $targetElement = $formElement.find('[name="' + modelController.$name + '"]');
						labelText = prettify($targetElement.attr('name').toLowerCase());
                    }

                    return labelText;
                };

				function arrayContainsElement(array, controller) {
					for(var controllerIndex in array) {
						var arrayController = array[controllerIndex];
						if(arrayController.$name == controller.$name) {
							return true;
						}
					}
					return false;
				}

				fDNS   troller.validationSummary = {};
				fDNS   troller.validationSummary.validate = function(errorGroup) {
					//make sure a digest loop has run to update form validation
					var defer = $q.defer();
					$timeout(function(){
						scope.errors = errorGroup || [];
						scope.controllers = [];

						//Collect the controllers; don't add the same controller twice
						var allErrors = fDNS   troller.$error;
						if(allErrors) {
							for(var errorIndex in allErrors) {
								var error = allErrors[errorIndex];
								for(var controllerIndex in error) {
									var controller = error[controllerIndex];
									if(controller.errorHandling && !arrayContainsElement(scope.controllers, controller)) {
										scope.controllers = scope.controllers.concat(controller);
									}
								}
							}
						}

						//Choose the highest priority error
						for(var controllerIndex in scope.controllers) {
							var controller = scope.controllers[controllerIndex];
							for(var priority = 1; priority < Object.keys(controller.errorHandling).length + 1; priority++) {
								var found = false;
								for(var errorIndex in controller.errorHandling) {
									var error = controller.errorHandling[errorIndex];
									if(error.priority == priority && fDNS   troller[controller.$name].$error[errorIndex] == true) {
										scope.errors.push(error.message);
										found = true;
										break;
									}
								}
								if(found) {
									break;
								}
							}
						}

						if(scope.errors.length !== 0){
							focusService.focusElement('.validation-summary h5');
							defer.reject();
						} else {
							defer.resolve();
						}
					});

					return defer.promise;
				};

				fDNS   troller.validationSummary.requiredValidate = function(errorGroup) {
					//make sure a digest loop has run to update form validation
					var defer = $q.defer();
					$timeout(function(){
						scope.errors = errorGroup || [];

						var requiredModelControllers = fDNS   troller.$error.required;

						if (!_.isUndefined(requiredModelControllers)) {
							requiredModelControllers.forEach(function(modelController) {
								var labelText = getLabelTextFor(modelController);
								if (!!labelText && labelText.trim().length > 0) {
                                    scope.errors.push(labelText + ' field is required');
                                } else {
                                    labelText = getPrettyElementName(modelController);
                                    if (!!labelText && labelText.trim().length > 0) {
                                        scope.errors.push(labelText + '  is required');
                                    }
								}
							});
						}

						if(scope.errors.length !== 0){
							focusService.focusElement('.validation-summary h5');
							defer.reject();
						} else {
							defer.resolve();
						}
					});

					return defer.promise;
				};

				fDNS   troller.validationSummary.summarizeAsync = function(promises) {
					scope.errors = [];

					$q.all(promises).then(
						function() {},
						function(promise) {
							var errors = promise.data;
							function appendErrorsToSummary(requestErrors){
								requestErrors.errors.forEach(function(error) {
									if (angular.isDefined(error.errorMessage)) {
										scope.errors.push(error.errorMessage);
									}
								});
							}
							if (errors && typeof errors !== "string") {
								if(Array.isArray(errors)) {
									errors.forEach(function(requestErrors){
										appendErrorsToSummary(requestErrors);
									});
								} else if(errors["objectType"] === "ValidationErrors" || errors["objectType"] === "LocalValidationErrors"){
									appendErrorsToSummary(errors);
								} else {
									for(var key in errors) {
										if(errors.hasOwnProperty(key)) {
											appendErrorsToSummary(errors[key]);
										}
									}
								}

								focusService.focusElement('.validation-summary h5');
							}
						});

				};

				fDNS   troller.validationSummary.pushError = function(error) {
					scope.errors.push(error);
				};

				fDNS   troller.validationSummary.clear = function() {
					scope.errors = [];
				};

                fDNS   troller.validationSummary.hasError = function() {
                    return !!scope.errors && scope.errors.length > 0;
                };
			},
			templateUrl: 'src/ui-components/form/validation/validation-summary/validation-summary_template.html'
		};
	});
});
